package parcial;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * @author Gonzalo
 */

public class FacturaComercial {
	ArrayList listaFacturas;
	
	FacturaComercial(){
		listaFacturas = new ArrayList();
	}
	
	// Constructor
	FacturaComercial (ArrayList lista){
		listaFacturas = lista;
	}
	
	public double calcularTotal(){
		// Si no tiene facturas devuelve 0.
		if (listaFacturas.size()>0){
			ArrayList listaHilos = new ArrayList();
			Iterator iter = listaFacturas.iterator();
			
			// Pongo a correr un hilo por cada elemento de la lista.
			while (iter.hasNext()) {
				Articulo articulo = (Articulo) iter.next();
				Hilo hilo = new Hilo(articulo);
				hilo.run();
				listaHilos.add(hilo);
			}
			
			double total = 0;
			boolean listo = false;
			
			/* Cuando los hilos terminen voy a ir borrandolos y sumarle su 
			   suma parcial a la variable 'total'. De esta forma, al terminar
			   de borrar todos los hilos de listaHilos voy a tener el total
			   en esta variable.
			 */
			while (!listo) {
				if (listaHilos.size()>0) {
					Iterator iter2 = listaHilos.iterator();
					while (iter2.hasNext()) {
						Hilo h = (Hilo) iter2.next();
						// Sino se murio el hilo, lo borro y lo sumo al 'total'.
						if (!h.isAlive()){
							total += h.getPrecio();
							iter2.remove();
						}
					}
				} else listo = true;
				// Si ya borre todos los hilos, termine.
			}
			return (total);
		} else return (0);
	}
}
